<?php
$config = include('config.php');

function callGitLabAPI($url) {
    global $config;

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'PRIVATE-TOKEN: ' . $config['gitlab_token']
    ]);

    $response = curl_exec($ch);
    curl_close($ch);

    return json_decode($response, true);
}

function getDevelopers() {
    global $config;
    $url = "{$config['gitlab_api_url']}/groups/{$config['gitlab_group_id']}/members";
    return callGitLabAPI($url);
}

function getUserCommits($userId) {
    global $config;
    $url = "{$config['gitlab_api_url']}/users/{$userId}/events?per_page=100";
    return callGitLabAPI($url);
}

function getCommitStats($projectId, $commitId) {
    global $config;
    $url = "{$config['gitlab_api_url']}/projects/{$projectId}/repository/commits/{$commitId}";
    return callGitLabAPI($url);
}

function getContributions() {
    $developers = getDevelopers();
    $contributions = [];

    if (!$developers) {
        return [];
    }

    foreach ($developers as $dev) {
        $userId = $dev['id'];
        $name = $dev['name'];
        $username = $dev['username'];

        $commits = getUserCommits($userId);
        $totalAdditions = 0;
        $totalDeletions = 0;

        if ($commits) {
            foreach ($commits as $commitEvent) {
                if (!isset($commitEvent['commit_id'], $commitEvent['project_id'])) {
                    continue;
                }

                $commitId = $commitEvent['commit_id'];
                $projectId = $commitEvent['project_id'];

                $commitDetails = getCommitStats($projectId, $commitId);

                if (isset($commitDetails['stats'])) {
                    $stats = $commitDetails['stats'];
                    $totalAdditions += $stats['additions'] ?? 0;
                    $totalDeletions += $stats['deletions'] ?? 0;
                }
            }
        }

        $contributions[] = [
            'name' => $name,
            'username' => $username,
            'linesAdded' => $totalAdditions,
            'linesRemoved' => $totalDeletions,
            'totalContributions' => $totalAdditions - $totalDeletions
        ];
    }

    return $contributions;
}
?>